<?php
/**
 * The template for displaying Search Results pages.
 *
 * @package sparkling
 */

get_header(); ?>

    <section id="primary" class="content-area custom-search-result">
        <main id="main" class="site-main" role="main">

        <?php if ( have_posts() ) : ?>

            <header class="page-header">
                <h1 class="page-title"><?php printf( esc_html__( 'Search Results for: %s', 'sparkling' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
            </header><!-- .page-header -->

            <div class="container">
              <div class="row">
                <div class="breadcrumbs">
                  <?php if(function_exists('bcn_display'))
                  {
                    bcn_display();
                  }?>
                </div>
              </div>
            </div>

            <?php /* Start the Loop */ ?>
            <?php //while ( have_posts() ) : the_post(); ?>

                <?php get_template_part( 'content', 'search-product' ); ?>

            <?php //endwhile; ?>

            <?php sparkling_paging_nav(); ?>

        <?php else : ?>

            <?php get_template_part( 'content', 'none' ); ?>

        <?php endif; ?>

        </main><!-- #main -->
    </section><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>
