<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package sparkling
 */
?>

<?php the_post_thumbnail( 'sparkling-featured', array( 'class' => 'single-featured' )); ?>

<div class="post-inner-content">
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header page-header">
		<h1 class="entry-title"><?php the_title(); ?></h1>
	</header><!-- .entry-header -->

	<div class="entry-content">

		<div class="container">
			<div class="row">
      
		        <div class="breadcrumbs">
		          <?php if(function_exists('bcn_display'))
		          {
		            bcn_display();
		          }?>
		        </div>

				<div class="custom-left-sidebar">
					<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('About Sidebar') ) :  endif; ?>
				</div>
				<div class="custom-contain">
					<h1 class="my-page-title">
						<span class="my-title"><?php the_title(); ?></span>
						<span class="my-deco"></span>
					</h1>
					<?php the_content(); ?>
				</div>
			</div>
		</div>
		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'sparkling' ),
				'after'  => '</div>',
			) );
		?>
    <?php
      // Checks if this is homepage to enable homepage widgets
      if ( is_front_page() ) :
        get_sidebar( 'home' );
      endif;
    ?>
	</div><!-- .entry-content -->
	<?php edit_post_link( esc_html__( 'Edit', 'sparkling' ), '<footer class="entry-footer"><i class="fa fa-pencil-square-o"></i><span class="edit-link">', '</span></footer>' ); ?>
</article><!-- #post-## -->
</div>