<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package sparkling
 */

get_header(); ?>

	<section id="primary" class="content-area my-product-main">
		<main id="main" class="site-main" role="main">

		<?php if ( have_posts() ) : ?>

			<header class="page-header">
				<h1 class="page-title">
					<?php
						if ( is_category() ) :
							single_cat_title();

						elseif ( is_tag() ) :
							single_tag_title();

						elseif ( is_author() ) :
							printf( esc_html__( 'Author: %s', 'sparkling' ), '<span class="vcard">' . get_the_author() . '</span>' );

						elseif ( is_day() ) :
							printf( esc_html__( 'Day: %s', 'sparkling' ), '<span>' . get_the_date() . '</span>' );

						elseif ( is_month() ) :
							printf( esc_html__( 'Month: %s', 'sparkling' ), '<span>' . get_the_date( _x( 'F Y', 'monthly archives date format', 'sparkling' ) ) . '</span>' );

						elseif ( is_year() ) :
							printf( esc_html__( 'Year: %s', 'sparkling' ), '<span>' . get_the_date( _x( 'Y', 'yearly archives date format', 'sparkling' ) ) . '</span>' );

						elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
							esc_html_e( 'Asides', 'sparkling' );

						elseif ( is_tax( 'post_format', 'post-format-gallery' ) ) :
							esc_html_e( 'Galleries', 'sparkling');

						elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
							esc_html_e( 'Images', 'sparkling');

						elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
							esc_html_e( 'Videos', 'sparkling' );

						elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
							esc_html_e( 'Quotes', 'sparkling' );

						elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
							esc_html_e( 'Links', 'sparkling' );

						elseif ( is_tax( 'post_format', 'post-format-status' ) ) :
							esc_html_e( 'Statuses', 'sparkling' );

						elseif ( is_tax( 'post_format', 'post-format-audio' ) ) :
							esc_html_e( 'Audios', 'sparkling' );

						elseif ( is_tax( 'post_format', 'post-format-chat' ) ) :
							esc_html_e( 'Chats', 'sparkling' );

						else :
							esc_html_e( 'Archives', 'sparkling' );

						endif;
					?>
				</h1>
				<?php
					// Show an optional term description.
					$term_description = term_description();
					if ( ! empty( $term_description ) ) :
						printf( '<div class="taxonomy-description">%s</div>', $term_description );
					endif;
				?>
			</header><!-- .page-header -->

			<?php /* Start the Loop */ ?>
			<?php //while ( have_posts() ) : the_post(); ?>

				<?php
					/* Include the Post-Format-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
					//get_template_part( 'content', get_post_format() );
				?>

			<?php //endwhile; ?>

			<div class="container">
	          <div class="row">
	            <div class="breadcrumbs">
	              <?php if(function_exists('bcn_display'))
	              {
	                bcn_display();
	              }?>
	            </div>
	          </div>
	        </div>


			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	          <?php //the_post_thumbnail( 'sparkling-featured', array( 'class' => 'single-featured' )); ?>
				<div class="post-inner-content">
					<div class="container">
						<section class="custom-product-container custom-category-list">

							<?php
								$current_cat_id = '';
								if (isset($_REQUEST["myid"])){
									$current_cat_id = $_REQUEST["myid"];
								}
          						
					        	$product_list2='';
						        $product_dropdown= '';

					        	if (empty($current_cat_id)){
						            $terms = get_terms("product-category",array('orderby' => 'id','hide_empty' => 0,'parent'=>0 ));
						        }else{
						        	$terms = get_terms("product-category",array('orderby' => 'id','hide_empty' => 0,'parent'=>$current_cat_id ));
						        }

						        if ( !empty( $terms ) && !is_wp_error( $terms && count($terms)) ){/* check sub category*/

						        	foreach ( $terms as $term ) {
						        		$product_list2.='<div class="mc_product">';
						        		$product_list2.='<div class="mc_product_wrapper">';
              							$term_link = get_term_link( $term );

						        		$subterms = get_terms("product-category",array('orderby'    => 'id','hide_empty' => 0,'parent'=>$term->term_id));
              								if ( !empty( $subterms ) && !is_wp_error( $subterms ) && count($subterms)){
              									$product_list2.='<a href="'.get_site_url().'/product/?myid='.$term->term_id.'">';
              								}else{
              									$product_list2.='<a href="'.$term_link.'">';
              								}

						        		$cat_img = types_render_termmeta("category-image", array( "term_id" => $term->term_id, "output"=>"raw"));
						        		if ( !empty($cat_img) ){
						        			$product_list2.='<div class="product_img"><img src="'.$cat_img.'"/></div>';
						        		}else{
						        			$product_list2.='<div class="product_img"><img src="'.get_template_directory_uri().'/images/no-image.png"/></div>';
						        		}
						        		
						        		$product_list2.='<div class="product_name">'. $term->name.'</div>';
						        		$product_list2.='</a>';
						        		$product_list2.='</div>';
						        		$product_list2.='</div>';
						        	}

						        	$args = array(
										     'post_type' => 'product'
		     								);
						        	$query = new WP_Query( $args ); 
    								if ( $query->have_posts() ) : while ( $query->have_posts() ) : $query->the_post();
    									$product_dropdown .= '<option value="'.get_permalink().'" >'.get_the_title().'</option>';
    								endwhile;
    								endif;


						        }else{/* if no category, list post*/

						        	$product_list2.='<div class="mc_product_list">';
						        	$args = array(
										     'post_type' => 'product',
										     'tax_query' => array(
											      array(
											      'taxonomy' => 'product-category',
											      'field' => 'id',
											      'terms' => $current_cat_id
											      )
										       )
		     								);
						        	$query = new WP_Query( $args ); 
    								if ( $query->have_posts() ) : while ( $query->have_posts() ) : $query->the_post();

    									$prodcut_count++;
            							$class= ($prodcut_count%3==0) ? 'row_last' :'';
    									$product_list2.='<div class="mc_product '.$class.'">';
						        		$product_list2.='<div class="mc_product_wrapper">';
						        		$product_list2.='<a href="'.get_permalink().'">';
						        		if ( has_post_thumbnail() ){
						        			$product_list2.='<div class="product_img">'.the_post_thumbnail().'</div>';
						        		}else{
						        			$product_list2.='<div class="product_img"><img src="'.get_template_directory_uri().'/images/no-image.png"/></div>';
						        		}
						        		
						        		$product_list2.='<div class="product_name">'. get_the_title().'</div>';
						        		$product_list2.='</a>';
						        		$product_list2.='</div>';
						        		$product_list2.='</div>';

    								endwhile;
      								else:
        								$product_list2 .= '<h2 class="no_result">No Products Found</h2>';
									endif;
									$product_list2.='</div>';
						        }
					        ?>

							<div class="page-left">
								<h3>Product Information</h3>
								<?php echo do_shortcode ('[wpb_category_accordion taxonomy="product-category" orderby="id" order="ASC" show_count="no" hide_empty="no"]'); ?>
								<div style="margin-top: 10px;"><a href="http://www.threebond.co.jp/en/catalog/catalog.html" target="_blank"><img src="/wp-content/uploads/2017/02/bnr-web-catalog.jpg"></a></div>
								<div style="height: 50px; clear:both;"></div>
							</div>

							<div class="right-content">
								<h1 class="my-page-title">
									<span class="my-title">Product Information</span>
									<span class="my-deco"></span>
								</h1>

								<p><strong>Introducing ThreeBond's high performance, original technology products.</strong></p>

								<div class="mc_product_list">
									<?php
										if ($_SERVER["REQUEST_METHOD"] == "POST") {
											if (empty($_POST["select_catalog"])) {
											    // $nameErr = "Selection is required";
											    // echo $nameErr;
											  }else{
											  	// $my_value = $_POST['select_catalog'];
											  	// echo $my_value ;
											  }
										}
									?>

									<form method="post" action=""  >
										<div>
											<select id="select_catalog">
												<option value="0">Please choose a product</option>
												<?php echo $product_dropdown; ?>
											</select>
										</div>
										<input class="btn btn-default" type="button" onclick="ddlValidate();" value="Submit">
									</form>

									<div style="clear:both;"></div>

									<?php echo $product_list2; ?>
								</div>

								<div style="clear:both;"></div>
								<?php //wp_pagenavi(array( 'query' => $args )); ?>
								<?php //echo easy_wp_pagenavigation(); ?>

								<div class="my-search-box">
									<h4>Search Product</h4>
									<?php echo do_shortcode("[search_product]");?>
									To search for products, SDS or technical information, enter the product name in the box.
								</div>

								<div class="home-redirect">
									<a href="#" class="btn btn-link btn-lg">Directions for Use of Products <i class="fa fa-angle-double-right" aria-hidden="true"></i></a>
									<a href="#" class="btn btn-link btn-lg">Product Safety Guide <i class="fa fa-angle-double-right" aria-hidden="true"></i></a>
								</div>

								<div style="clear:both;"></div>

								<div class="my-product-intro">
									<h1 class="my-page-title">
										<span class="my-title">Product Introduction</span>
										<span class="my-deco"></span>
									</h1>

									<div class="my-box">
										<div class="left-col">
											<span class="my-txt">These are examples of products.<br>To inquire about other products, please click here.</span>
											<span class="left-border"></span>
										</div>
										<div class="right-col">
											<a class="btn btn-default" href="<?php get_template_directory_uri(); ?>/questions"><i class="fa fa-chevron-right" aria-hidden="true"></i> Questions</a>
										</div>
									</div>

									<div class="my-box-2">
										<h4>ThreeBond Technical Information</h4>
										<div class="my-wrapper">
											<div class="col-sm-4">
												<div class="my-box">
													<h5>
														<div class="img-wrapper"><img src="<?php echo get_template_directory_uri(); ?>/images/tech-icon1.jpg"/></div>
														<span>Technical News</span>
													</h5>
													<p>Introduction of ThreeBond technology</p>
												</div>
											</div>
											<div class="col-sm-4">
												<div class="my-box">
													<h5>
														<div class="img-wrapper"><img src="<?php echo get_template_directory_uri(); ?>/images/tech-icon2.jpg"/></div>
														<span>Latest Information on Technology and Material</span>
													</h5>
													<p>Introduction of the latest ThreeBond technology by keyword</p>
												</div>
											</div>
											<div class="col-sm-4">
												<div class="my-box">
													<h5>
														<div class="img-wrapper"><img src="<?php echo get_template_directory_uri(); ?>/images/tech-icon3.jpg"/></div>
														<span>Seminars on Adhesives</span>
													</h5>
													<p>An easy-to-understand introduction of adhesives, such as how adhesives work</p>
												</div>
											</div>
										</div>
									</div>

								</div>


							</div>
						</section>
					</div>
				</div>
			</article>

			<?php //sparkling_paging_nav(); ?>

		<?php else : ?>

			<?php get_template_part( 'content', 'none' ); ?>

		<?php endif; ?>

		</main><!-- #main -->
	</section><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>