<?php
/**
 * Woocommerce functions
 * @package ninja
 */

// Remove WooCommerce Updater
remove_action('admin_notices', 'woothemes_updater_notice');
// Reorder woocommerce breadcrumbs
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
// Remove default sorting dropdown
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
// Remove default woocommerce sidebar
remove_action ('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);
// Remove sale flash badge
add_filter('woocommerce_sale_flash', 'woo_custom_hide_sales_flash');
function woo_custom_hide_sales_flash() { return false; }

/**
 * Create opening and closing divs for product content section
 **/
add_action('woocommerce_before_main_content', 'woo_opening_product_content_div', 30);
function woo_opening_product_content_div(){
    echo '<div class="product-content">';
}

add_action('woocommerce_after_main_content', 'woo_closing_product_content_div', 5);
function woo_closing_product_content_div(){
    echo '</div> <!-- .product-content -->';
}

add_action('woocommerce_before_single_product_summary', 'woo_container_product_summary_open', 5);
function woo_container_product_summary_open(){
    echo '<div class="container">';
}

add_action('woocommerce_after_single_product_summary', 'woo_container_product_summary_close', 15);
function woo_container_product_summary_close(){
    echo '</div>';
}

/**
 * Remove add to cart button on shop
 */
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
/**
 * Add Read More button for products on shop
 */
function replace_add_to_cart() {
    _e('<span class="btn-read-more"><i class="fas fa-link"></i></span>');
}
add_action('woocommerce_after_shop_loop_item_title', 'replace_add_to_cart', 15);
/**
 * Change number of products per row on shop
 */
if (!function_exists('loop_columns')) {
    function loop_columns() {
        return 4; // products per row
    }
}
add_filter('loop_shop_columns', 'loop_columns');
/**
 * Change number of related products on product page
 */ 
add_filter( 'woocommerce_output_related_products_args', 'ninja_related_products_args' );
function ninja_related_products_args( $args ) {
    $args['posts_per_page'] = 4; // max related products
    $args['columns'] = 4; // products per row
    return $args;
}
/**
 * Change number of products that are displayed per page (shop page)
 */
add_filter( 'loop_shop_per_page', 'new_loop_shop_per_page', 20 );
function new_loop_shop_per_page( $cols ) {
    $cols = 12;
    return $cols;
}
/**
 * Remove product meta in single page
 */
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
/**
 * Remove product price
 */
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 20 );
/**
 * Remove after shop loop item title
**/
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating',5);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price',10);
/**
 * Remove upsell display, tabs
 */
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
/**
 * Remove reviews tab
 */
add_filter( 'woocommerce_product_tabs', 'ninja_woo_remove_reviews_tab', 98 );
function ninja_woo_remove_reviews_tab($tabs) {
    unset($tabs['reviews']);
    return $tabs;
}
/*
 * Replace WooCommerce Default Pagination with WP-PageNavi
 */
remove_action('woocommerce_pagination', 'woocommerce_pagination', 10);
function woocommerce_pagination() {
    ninja_navigation();
}
add_action( 'woocommerce_pagination', 'woocommerce_pagination', 10);
/**
 * Remove unnecessary product data tabs on backend
 */
function remove_tab($tabs){
    unset($tabs['inventory']);
    unset($tabs['shipping']);
    unset($tabs['advanced']);
    unset($tabs['linked_product']);
    unset($tabs['attribute']);
    unset($tabs['variations']);
    return($tabs);
}
add_filter('woocommerce_product_data_tabs', 'remove_tab', 10, 1);
/**
 * Product Lightbox
 */
add_theme_support( 'wc-product-gallery-lightbox' );
add_theme_support( 'wc-product-gallery-slider' );

/**
 * Product Carousel
 */
add_shortcode('latest_products_carousel', 'latest_products_carousel' );
function latest_products_carousel($atts, $content = null){
    $atts = shortcode_atts( array(
                'xclass'    => '',
                'limit'     => 12,
            ), $atts, '' );
    $class = $atts['xclass'];
    $post_limit = $atts['limit'];

    $args = array(  
        'post_type'     => 'product',
        'showposts'     => $post_limit,
        'order'         => 'desc',
        'orderby'       => 'date',
    );

    $loop = new WP_Query( $args );
          
    if ($loop->have_posts()) :
        $output = '';
        $output .= '<div class="products-carousel woocommerce '.$class.'">';
        $output .= '<ul class="products ">';
        while ( $loop->have_posts() ) : $loop->the_post(); global $product;
            ob_start();
            wc_get_template_part( 'content', 'product' );
            $output .= ob_get_contents();
            ob_get_clean();
        endwhile;
        $output .= '</ul>';
        $output .= '</div><!-- #products-carousel -->';
    else:
        $output .= '<h6 class="text-center nmb30">No products available.</h6>';
    endif;
    wp_reset_query();

    return $output;
}

/**
 * Allow backend access for non-admin users
 */
add_action( 'init', 'allow_backend_access_for_subscriber' );
function allow_backend_access_for_subscriber(){
    if ( current_user_can( 'subscriber' ) ):
        add_filter( 'woocommerce_disable_admin_bar', '__return_false' );
    endif;
}

/**
 * Remove menu items from admin bar
 */
function remove_menu_items_admin_bar() {
    if ( current_user_can( 'subscriber' ) ):
        global $wp_admin_bar;
        $wp_admin_bar->remove_menu('dashboard');
        $wp_admin_bar->remove_menu('user-info');
        $wp_admin_bar->remove_menu('edit-profile');
    endif;
 }
add_action('wp_before_admin_bar_render', 'remove_menu_items_admin_bar', 0);

/**
 * Remove menu items from admin bar
 */
add_action('wp_logout','auto_redirect_after_logout');
function auto_redirect_after_logout(){
    if ( current_user_can( 'subscriber' ) ):
        wp_redirect( home_url() );
        exit();
    endif;
}

/**
 * Set default price
 */
function woo_set_default_price( $post_id, $post ) {
    if ( isset( $_POST['_regular_price'] ) && trim( $_POST['_regular_price'] ) == '' ) {
        update_post_meta( $post_id, '_regular_price', '0' );
    }
}
add_action( 'woocommerce_process_product_meta', 'woo_set_default_price' );
add_filter('woocommerce_is_purchasable', '__return_TRUE');

/**
 * Add product gallery after product summary
 */
add_action( 'woocommerce_after_single_product_summary', 'woo_custom_product_gallery', 15 );
function woo_custom_product_gallery(){

    $output = null;

    $cf_post_ids = toolset_get_related_posts(
                        get_the_ID(), // the parent post
                        'cp-gallery', // the RFG slug
                        'parent', // the RFG role in this relationship is child
                        100, // max number of results
                        0, // the offset
                        array(), // additional query args
                        'post_id', // return format
                        'child' // role to return
                    );

    if ( $cf_post_ids ){

        $all_cf_keys = $cf_keys = array();

        foreach ( $cf_post_ids as $cf_post_id ){

            $cf_keys = get_post_meta( $cf_post_id, '', false );
            $cf_keys['post_title'] = get_the_title( $cf_post_id );

            $all_cf_keys[] = $cf_keys;

            $cf_sort_order = array();
            $cf_sort_order = array_column($all_cf_keys, 'toolset-post-sortorder');
            array_multisort($cf_sort_order, SORT_ASC, $all_cf_keys);

        }

        $output .= '<section class="custom-product-gallery">';
        $output .= '<div class="container product-gallery-inner grid-container">';

        // Display custom fields
        foreach ( $all_cf_keys as $my_cf_key ){
            
            $image_title    = $my_cf_key["post_title"];
            $image_url      = $my_cf_key["wpcf-gallery-image"][0];

            $output .= '<div class="gallery-item">';
            $output .= '<img class="model-image" src="'. $image_url .'" />';
            $output .= '<h3 class="model-title">'. $image_title .'</h3>';
            $output .= '</div>';

        }

        $output .= '</div>';
        $output .= '</section>';
        echo $output;
        
    }

}

/**
 * Product Carousel
 */
add_shortcode('product_carousel', 'product_carousel' );
function product_carousel($atts, $content = null){
    $atts = shortcode_atts( array(
                'xclass'    => '',
                'limit'     => 12,
            ), $atts, '' );
    $class = $atts['xclass'];
    $post_limit = $atts['limit'];

    $args = array(  
        'post_type'     => 'product',
        'showposts'     => $post_limit,
        'order'         => 'desc',
        'orderby'       => 'date',
    );

    $loop = new WP_Query( $args );
          
    if ($loop->have_posts()) :
        $output = '';
        $output .= '<div class="products-carousel woocommerce '.$class.'">';
        $output .= '<ul class="products owl-carousel owl-theme owl-mytheme">';
        while ( $loop->have_posts() ) : $loop->the_post(); global $product;
            ob_start();
            wc_get_template_part( 'content', 'product' );
            $output .= ob_get_contents();
            ob_get_clean();
        endwhile;
        $output .= '</ul>';
        $output .= '</div><!-- #products-carousel -->';
    else:
        $output .= '<h6 class="text-center nmb30">No products available.</h6>';
    endif;
    wp_reset_query();

    return $output;
}