<?php
/**
 * Template Name: Thank You Template
 * The standard template used for thank you pages
 * @package ninja
 */
get_header(); ?>
	

<div id="primary" class="content-area">

	<main id="main" class="site-main" role="main">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<div id="container" class="ninja-thank-you">
			<div class="row">
				<div class="col-sm-12 tq-content text-center nvm30">
	                <i class="fa fa-paper-plane ninja-tq-icon" style="" aria-hidden="true"></i>
					<h1 class="entry-title">Thanks for Reaching Out!</h1>
					<p>We appreciate your interest in us.</p>
					<p>Your message has been successfully sent and it will soon be dealt with.</p>
					<p>This page will be redirected in</p>
					<div class="countdown">
						<div class="countdown-number"></div>
						<svg>
							<circle r="18" cx="20" cy="20"></circle>
						</svg>
					</div>
			          <a class="btn btn-default" title="<?php bloginfo('name'); ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>">Back to Home</a>
				</div>
			</div><!-- .row -->
		</div><!-- #container -->

	<?php endwhile; else : ?>
		<p><?php _e( 'Sorry, there is nothing here. Perhaps searching might help.' ); ?></p>
		<?php get_search_form(); ?>
	<?php endif; ?>

	</main><!-- #main -->
</div><!-- #primary -->

<?php get_footer(); ?>