<?php
    defined( 'ABSPATH' ) || exit;

/**
 * Enqueue scripts and styles.
 */
function ninja_scripts() {

    // Load jquery
    wp_enqueue_script('jquery');
    
    // Bootstrap default CSS
    wp_enqueue_style( 'ninja-bootstrap', get_template_directory_uri() . '/inc/css/bootstrap.min.css', array(), '220718' );
  
    // Font Awesome
    wp_enqueue_style( 'ninja-icons', '//use.fontawesome.com/releases/v6.1.1/css/all.css' );
  
    // Google Fonts
    wp_enqueue_style( 'ninja-fonts', '//fonts.googleapis.com/css2?family=Lato:wght@400;700&display=swap');
  
    // Main theme stylesheet
    wp_enqueue_style( 'ninja-style', get_stylesheet_uri() );
  
    // Custom style
    wp_enqueue_style( 'ninja-custom-style', get_template_directory_uri().'/custom.css' );
  
    // Responsive style
    wp_enqueue_style( 'ninja-responsive-style', get_template_directory_uri().'/responsive.css' );
  
    // Accordion script
    wp_enqueue_script( 'accordion-script', get_stylesheet_directory_uri() . '/js/jquery.navgoco.min.js', array('jquery'), '', true );
  
    // Main theme related functions
    wp_enqueue_script( 'ninja-functions', get_template_directory_uri() . '/inc/js/scrollTopPage.js', array('jquery'), '', true );
  
    // Smooth scroll script
    wp_enqueue_script( 'smooth-scroll-script', get_template_directory_uri() . '/inc/js/smooth.scroll.js', array('jquery'), '', true );

    // Slick Carousel Js
    wp_enqueue_script( 'slick-js', get_template_directory_uri() . '/slick/slick.min.js', array('jquery'), '', true );

    // Slick Carousel Css
    wp_enqueue_style( 'slick-css', get_template_directory_uri().'/slick/slick.css', '', true );

    // Slick Carousel Theme
    wp_enqueue_style( 'slick-theme', get_template_directory_uri().'/slick/slick-theme.css' );
  
    // Custom scripts
    if ( is_page_template('page-thankyou.php') ) {
      wp_enqueue_script( 'thank-you-script', get_template_directory_uri() . '/js/tqcountdown.js', array('jquery') ,'1.', true);
    }
    //wp_enqueue_script( 'parallax-script', get_template_directory_uri() . '/js/parallax.js', array('jquery') );
    wp_enqueue_script( 'custom-script', get_template_directory_uri() . '/js/custom.js', array('jquery'), '', true );
  
}
add_action( 'wp_enqueue_scripts', 'ninja_scripts' );

if ( ! isset( $content_width ) ) { $content_width = 648; /* pixels */ }

/**
 * Set the content width for full width pages with no sidebar.
 */
function ninja_content_width() {
  if ( is_page_template( 'page-fullwidth.php' ) ) {
    global $content_width;
    $content_width = 1008; /* pixels */
  }
}
add_action( 'template_redirect', 'ninja_content_width' );

/**
 * Set container based on template
 */
function set_ninja_container(){
    $container = [];
    $templates = [];

    $templates = ['page-fullwidth.php', 'page-home.php'];

    if ( is_page_template($templates) ) {
        $container['container_type'] = 'container-fluid';
    }else{
        $container['container_type'] = 'container';
    }

    return $container;
}

function ninja_container(){
    $container = set_ninja_container();
    $ninja_container = $container['container_type'];
    return $ninja_container;
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
if ( ! function_exists( 'ninja_setup' ) ) :
    function ninja_setup() {
        // Make theme available for translation. Translations can be filed in the /languages/ directory.
        //load_theme_textdomain( 'ninja', get_template_directory() . '/languages' );

        // Enable support for Post Thumbnails on posts and pages.
        add_theme_support( 'post-thumbnails' );
        // This theme uses wp_nav_menu() in one location.
        register_nav_menus( 
            array(
            'primary'      => esc_html__( 'Primary Menu', 'ninja' ),
            'social-menu'  => esc_html__( 'Social Menu', 'ninja' ),
            ) 
        );
        // Enable support for HTML5 markup.
        add_theme_support( 'html5', array(
            'search-form',
            'gallery',
            'caption'
        ) );
        // Let WordPress manage the document title in the document head.
        add_theme_support( 'title-tag' );
        // Enable support for WooCommerce.
        add_theme_support( 'woocommerce' );


        // Add theme support for Custom Logo.
        add_theme_support(
            'custom-logo',
            array(
                'width'      => 220,
                'height'     => 125,
                'flex-width' => true,
            )
        );
        
    }
endif; // ninja_setup
add_action( 'after_setup_theme', 'ninja_setup' );

/**
 * Register widgetized area and update sidebar with default widgets.
 */
function ninja_widgets_init() {

    register_sidebar( array(
        'id'            => 'sidebar-widget',
        'name'          => esc_html__( 'Sidebar', 'ninja' ),
        'description'   => esc_html__( 'The default sidebar widget', 'ninja' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
    ) );

    register_sidebar( array(
        'id'            => 'header-widget',
        'name'          => esc_html__( 'Header Widget Area', 'ninja' ),
        'description'   => esc_html__( 'The header widget area', 'ninja' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
    ) );

    register_sidebar( array(
        'id'            => 'footer-widget',
        'name'          => esc_html__( 'Footer Widget Area', 'ninja' ),
        'description'   => esc_html__( 'The footer widget area', 'ninja' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
    ) );

     register_sidebar( array(
        'id'            => 'floating-widget',
        'name'          => esc_html__( 'Floating Widget', 'ninja' ),
        'description'   => esc_html__( 'Floating Widget', 'ninja' ),
        'before_widget' => '<div id="%1$s" class="floating widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
     ) );

    register_sidebar( array(
        'id'            => 'product-sidebar-widget',
        'name'          => esc_html__( 'Product Sidebar', 'ninja' ),
        'description'   => esc_html__( 'The product sidebar widget', 'ninja' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
    ) );

    register_widget( 'ninja_social_widget' );
}
add_action( 'widgets_init', 'ninja_widgets_init' );

/**
 * Theme Widgets
 */
require_once(get_template_directory() . '/inc/widget-social.php');
//if( function_exists( 'elementor_load_plugin_textdomain' ) ) {require_once('custom-widgets/my-widgets.php');}

/**
 * Unregister all unnecessary widgets 
 */
function ninja_unregister_default_widgets() {
    unregister_widget('WP_Widget_Pages');
    unregister_widget('WP_Widget_Calendar');
    unregister_widget('WP_Widget_Links');
    unregister_widget('WP_Widget_Meta');
    unregister_widget('WP_Widget_Recent_Comments');
    unregister_widget('WP_Widget_Recent_Posts');
    unregister_widget('WP_Widget_RSS');
    unregister_widget('WP_Widget_Tag_Cloud');

    // WOO WIDGETS
    unregister_widget( 'WC_Widget_Layered_Nav' );
    unregister_widget( 'WC_Widget_Layered_Nav_Filters' );
    unregister_widget( 'WC_Widget_Price_Filter' );
    unregister_widget( 'WC_Widget_Product_Tag_Cloud' );
    unregister_widget( 'WC_Widget_Recent_Reviews' );
    unregister_widget( 'WC_Widget_Recently_Viewed' );
    unregister_widget( 'WC_Widget_Top_Rated_Products' );
} 
add_action('widgets_init', 'ninja_unregister_default_widgets', 11);

/**
 * This function removes inline styles set by WordPress gallery.
 */
function ninja_remove_gallery_css( $css ) {
  return preg_replace( "#<style type='text/css'>(.*?)</style>#s", '', $css );
}
add_filter( 'gallery_style', 'ninja_remove_gallery_css' );

function woocommerce_styling(){
    wp_enqueue_style( 'woocommerce-style', get_template_directory_uri().'/woocommerce/woocommerce.css' );
}

if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
    add_action( 'wp_enqueue_scripts', 'woocommerce_styling' );
    require get_template_directory() . '/woocommerce/woo-functions.php';
}

/**
 * Extra functions for this theme.
 */
require get_parent_theme_file_path() . '/inc/navwalker.php'; // CUSTOM NAV WALKER
require get_parent_theme_file_path() . '/inc/navigation.php'; // NAVIGATION RELATED FUNCTIONS
require get_parent_theme_file_path() . '/inc/extras.php'; // THEME RELATED FUNCTIONS

/**
 * Default Excerpt Length
 */
function ninja_excerpt_length( $length ) {
    return 25;
}
add_filter( 'excerpt_length', 'ninja_excerpt_length', 999 );

/**
 * Shortcodes in excerpt and widgets
 */
add_filter('the_excerpt', 'do_shortcode');
add_filter('widget_text','do_shortcode');

/**
 * Allow shortcodes inside Contact Form 7 forms
 */
function shortcode_wpcf7_form( $form ) {
    $form = do_shortcode( $form );
    return $form;
}
add_filter( 'wpcf7_form_elements', 'shortcode_wpcf7_form' );

/**
 * Create layout for ninja breadcrumbs
 */
function ninja_breadcrumbs(){

    if ( function_exists('bcn_display') ){
        $output = '';
        $output .= '<!--start breadcrumbs--><div class="breadcrumbs">';

        $container = set_ninja_container();
        $ninja_container = $container['container_type'];
        $breadcrumbs = bcn_display(true, true, false);

        if ( $ninja_container == 'container-fluid' ){
            $output .= '<div class="container"><div class="row"><div class="col-sm-12">';
            $output .= $breadcrumbs;
            $output .= '</div></div></div>';
        }else{
            $output .= $breadcrumbs;
        }
        
        $output .= '</div><!--end breadcrumbs-->';
        echo $output;
    }

}
add_action( 'ninja_breadcrumbs', 'ninja_breadcrumbs');

/**
 * Set pagenavi plugin as default navigation
 */
function ninja_navigation(){
    if ( function_exists('wp_pagenavi') ) { wp_pagenavi(); }
}
add_action( 'ninja_navigation', 'ninja_navigation');

/**
 * Remove archive type from title
 */
add_filter( 'get_the_archive_title', 'remove_prefix_archive_title' );
function remove_prefix_archive_title ($title) {
    if ( is_category() ) {
        $title = single_cat_title( '', false );
    } elseif ( is_tag() ) {
        $title = single_tag_title( '', false );
    } elseif ( is_author() ) {
        $title = '<span class="vcard">' . get_the_author() . '</span>' ;
    } elseif ( is_tax() ){
        $title = single_term_title( '', false );
    } elseif ( is_post_type_archive() ){
        $title = post_type_archive_title( '', false );
    }
    return $title;
}

/* Hide WP version strings from scripts and styles
* @return {string} $src
* @filter script_loader_src
* @filter style_loader_src
*/
function ninja_remove_wp_version_strings( $src ) {
    global $wp_version;
    parse_str(parse_url($src, PHP_URL_QUERY), $query);
    if ( !empty($query['ver']) && $query['ver'] === $wp_version ) {
        $src = remove_query_arg('ver', $src);
    }
    return $src;
}
add_filter( 'script_loader_src', 'ninja_remove_wp_version_strings' );
add_filter( 'style_loader_src', 'ninja_remove_wp_version_strings' );

/* Hide WP version strings from generator meta tag */
function ninja_remove_version() {
    return '';
}
add_filter('the_generator', 'ninja_remove_version');

/**
 * Grab all Toolset Types Custom Fields by Group ID or Group Slug
 */
function types_render_group($target_group) {
    global $post;
    require_once WPCF_EMBEDDED_INC_ABSPATH . '/fields.php';
     
    //by known group_id
    if(is_numeric($target_group)){
        return wpcf_admin_fields_get_fields_by_group($target_group);
    }
    //by known slug
    else{
        $groups = wpcf_admin_fields_get_groups();
        foreach($groups AS $group){
            if($group['slug'] == $target_group){
                return wpcf_admin_fields_get_fields_by_group($group['id']);
            }
        }
    }
    //check yourself, dude
    return false;
}


/** 
 *
 * @shortcode [floating-btn] 
 * @return string - widget or custom Html for the floating CTA button
 * @use - in wp_dasboard > appearance > Widgets > "Floating Widget" apply any custom HTML or widget to display on floating section.  
 *  
 */
add_shortcode( 'floating-btn', 'floating_btn' );
function floating_btn(){ do_shortcode(dynamic_sidebar("floating-widget")); }

/** 
 *
 * @shortcode [product-sidebar] 
 * @return string - widget or custom Html for the product/shop sidebar 
 * @use - in wp_dasboard > appearance > Widgets > "Product Sidebar" apply any custom HTML or widget to display on product/shop sidebar section.  
 *  
 */
add_shortcode( 'product-sidebar', 'product_sidebar' );
function product_sidebar(){ ob_start(); do_shortcode(dynamic_sidebar("product-sidebar-widget"));  return ob_get_clean(); }

/** 
 *
 * function:dump($param)
 * @return any - display result of output in readable format.
 * @desc - this func also can use to debug a script or inspect the output of a result  
 *  
 */
function dump($d){ echo('<pre>'); var_dump($d); echo('</pre>'); }



/**
 * Dynamic show homepage star product shortcode
 */
function star_product_dynamic($atts, $content = null){

  $atts = shortcode_atts( array(
           'href'   => '',
           'title'   => '',
           'img_url'  => '',
    ), $atts );

    $href = $atts['href'];
    $title = $atts['title'];
    $img_url = $atts['img_url'];


    $html = '';
    $html .= '<div class="block inner-nbox star-inner-nbox">';
    $html .= '<a href="'.$href.'">';
    $html .= '<div class="img-wrapper"><img src="'.$img_url.'"/></div>';
    $html .= '<h5 class="front-title">'.$title.'</h5>';  
    $html .= '<div class="contain-wrapper">';
    $html .= '<div class="inner-contain-wrapper">';
    $html .= '<h5 class="">'.$title.'</h5>';  
    $html .= '<div class="post-content">'.do_shortcode($content).'</div>';
    $html .= '<div class="btn btn-default deco-btn">Read More</div>';
    $html .= '</div>';//inner-contain-wrapper
    $html .= '</div>';//contain-wrapper
    $html .= '</a>';
    $html .= '</div>';//inner-nbox
            
  return $html;
}
add_shortcode( 'star_product_dynamic', 'star_product_dynamic');




/**********
**** List Star Products Category
*********/
add_shortcode( 'ninja_starCatList', 'ninja_starCatList' );
function ninja_starCatList(){
    $postList ='';
    $taxonomy_name = 'star-product';
    $args = array( 
                    'taxonomy' => $taxonomy_name, 
                    'orderby' => 'id', 
                    'order' => 'ASC', 
                    'hide_empty' => 0,
                    'parent' => 0,
                    // 'exclude' => 15,
                ); 
    $terms = get_terms( $args );
    if ( !empty( $terms ) && !is_wp_error( $terms && count($terms)) ){
        $postList = '<ul class="cat-list cat-listing ntype-list star-product-cat-list slick-star-product custom-slick-template">';

        foreach ( $terms as $term ) {
            $image = types_render_termmeta("star-product-image", array( "term_id" => $term->term_id, "output"=>"raw") );
            $href = types_render_termmeta("internal-link", array( "term_id" => $term->term_id, "output"=>"raw") );
            $desc = types_render_termmeta("star-product-short-description", array( "term_id" => $term->term_id, "output"=>"raw") );

            $postList .= '<li>';
            $postList .= '<div class="block inner-nbox star-inner-nbox">';
            $postList .= '<a href="'.$href.'">';
            $postList .= '<div class="img-wrapper"><img src="'.$image.'"/></div>';
            $postList .= '<h5 class="front-title">'.$term->name.'</h5>';  
            $postList .= '<div class="contain-wrapper">';
            $postList .= '<div class="inner-contain-wrapper">';
            $postList .= '<h5 class="">'.$term->name.'</h5>';  
            $postList .= '<div class="post-content">'.$desc.'</div>';
            $postList .= '<div class="btn btn-default deco-btn">Read More</div>';
            $postList .= '</div>';//inner-contain-wrapper
            $postList .= '</div>';//contain-wrapper
            $postList .= '</a>';
            $postList .= '</div>';//inner-nbox
            $postList .= '</li>';
        }
        $postList.='</ul><!--end product category-->';
    }
    return $postList;

}




/**********
**** List Products Parent Category
*********/
add_shortcode( 'ninja_procatList', 'ninja_procatList' );
function ninja_procatList(){
    $postList ='';
    $taxonomy_name = 'product_cat';
    $args = array( 
                    'taxonomy' => $taxonomy_name, 
                    'orderby' => 'id', 
                    'order' => 'ASC', 
                    'hide_empty' => 0,
                    'parent' => 0,
                    'exclude' => 15,
                ); 
    $terms = get_terms( $args );
    if ( !empty( $terms ) && !is_wp_error( $terms && count($terms)) ){
        $postList = '<ul class="cat-list cat-listing ntype-list home-product-cat-list">';

        foreach ( $terms as $term ) {
            $thumbnail_id = get_term_meta( $term->term_id, 'thumbnail_id', true );
            $image = wp_get_attachment_url( $thumbnail_id );
            $postList .= '<li>';
            $postList .= '<div class="block inner-nbox">';
            $postList .= '<a href="'.get_term_link( $term ).'" class="">';
            $postList .= '';
            if ( $image ) {
                $postList .= '<div class="img-wrapper"><img src="'.$image.'"/></div>';
            }
            $postList .= '<h5 class="featured-post-title">'.$term->name.'</h5>';
            $postList .= '</a>';
            $postList .= '</div>';
            $postList .= '</li>';
        }
        $postList.='</ul><!--end product category-->';
    }
    return $postList;

}



/**********
**** List News & Events Posts
*********/
add_shortcode( 'ninja_newsEventsPost', 'ninja_newsEventsPost' );
function ninja_newsEventsPost(){
    
    // $queried_object = get_queried_object();
    // $current_term_id =  (int) $queried_object->term_id;

    $postList ='';
    $postList ='<ul class="cat-list cat-listing ntype-list news-event-list-template news-event-list slick-event-list custom-slick-template">';
    $args = array(
            'post_type' => 'post',
            'orderby' => 'id',
            'order'   => 'ASC',
            'posts_per_page' => '6',
            'tax_query' => array(
                array(
                    'taxonomy' => 'category',
                    'terms'    => '23',
                ),
            ),
        );
    $query = get_posts( $args ); 

    if ( $query ) :
        foreach ($query as $post) {
            $venue = types_render_field("venue", array("post_id"=>$post->ID, "output"=>"raw"));
            if ( has_post_thumbnail($post->ID) ) { // check if the post has a Post Thumbnail assigned to it.
                $thumb_id = get_post_thumbnail_id($post->ID);
                $thumb_url_array = wp_get_attachment_image_src($thumb_id, 'thumbnail-size', true);
                $thumb_url = $thumb_url_array[0];
            } 

            $postList .= '<li>';
            $postList .= '<a href="'.get_the_permalink($post->ID).'" >';
            $postList .= '<div class="block inner-nbox">';
            $postList .= '<div class="img-wrapper"><img src="'.$thumb_url.'"/></div>';
            $postList .= '<div class="content-nbox">';
            // $postList .= '<div class="post-date">'.$custom_date.'</div>';
            $postList .= '<h5 class="post-title">'.get_the_title($post->ID).'</h5>';
            if(!empty($venue)){
                $postList .= '<h6 class="post-subtitle">'.$venue.'</h6>';
            }
            
            $postList .= '<div class="deco-btn"> See More </div>';
            $postList .= '</div>';
            $postList .= '</div>';
            $postList .= '</a>';
            $postList .= '</li>';
        }

    else:
        echo "no post";
    endif;
            $postList .= '</ul>';

    return $postList; 
    wp_reset_query();
}



/**********
**** List Related News & Events Posts
*********/
add_shortcode( 'ninja_RelatedNewsEvents', 'ninja_RelatedNewsEvents' );
function ninja_RelatedNewsEvents(){
    
    $queried_object = get_queried_object();
    $current_post_id =  (int) $queried_object->ID;
    

    $postList ='';
    $postList ='<ul class="cat-list cat-listing ntype-list news-event-list-template related-news-event-list">';
    $args = array(
            'post_type' => 'post',
            'orderby' => 'id',
            'order'   => 'ASC',
            'posts_per_page' => '3',
            'exclude'=> $current_post_id,
            'tax_query' => array(
                array(
                    'taxonomy' => 'category',
                    'terms'    => '23',
                ),
            ),
        );
    $query = get_posts( $args ); 

    if ( $query ) :
        foreach ($query as $post) {
            $venue = types_render_field("venue", array("post_id"=>$post->ID, "output"=>"raw"));
            if ( has_post_thumbnail($post->ID) ) { // check if the post has a Post Thumbnail assigned to it.
                $thumb_id = get_post_thumbnail_id($post->ID);
                $thumb_url_array = wp_get_attachment_image_src($thumb_id, 'thumbnail-size', true);
                $thumb_url = $thumb_url_array[0];
            } 

            $postList .= '<li>';
            $postList .= '<a href="'.get_the_permalink($post->ID).'" >';
            $postList .= '<div class="block inner-nbox">';
            $postList .= '<div class="img-wrapper"><img src="'.$thumb_url.'"/></div>';
            $postList .= '<div class="content-nbox">';
            // $postList .= '<div class="post-date">'.$custom_date.'</div>';
            $postList .= '<h5 class="post-title">'.get_the_title($post->ID).'</h5>';
            if(!empty($venue)){
                $postList .= '<h6 class="post-subtitle">'.$venue.'</h6>';
            }
            
            $postList .= '<div class="deco-btn"> See More </div>';
            $postList .= '</div>';
            $postList .= '</div>';
            $postList .= '</a>';
            $postList .= '</li>';
        }

    else:
        echo "no post";
    endif;
            $postList .= '</ul>';

    return $postList; 
    wp_reset_query();
}




/**********
**** List Vacancies Posts
*********/
add_shortcode( 'ninja_vacancies', 'ninja_vacancies' );
function ninja_vacancies(){  

    $postList ='';
    $shortcode = '';
    $title = '';
    $args = array(
            'post_type' => 'vacancy',
            'orderby' => 'id',
            'order'   => 'ASC',
            'posts_per_page' => '-1',
            // 'exclude'=> $current_post_id,
            // 'tax_query' => array(
            //     array(
            //         'taxonomy' => 'category',
            //         'terms'    => '23',
            //     ),
            // ),
        );
    $query = get_posts( $args ); 

    if ( $query ) :
        foreach ($query as $post) {
            $department = types_render_field("department", array("post_id"=>$post->ID, "output"=>"raw"));
            if (!empty($department)){
                $department = '('.$department.' Department)';
            }

            // $postList .= '[su_spoiler title="<h6>'.get_the_title($post->ID).'</h6><div>'.$department.'</div>" style="fancy"] '.get_the_content($post->ID).' [/su_spoiler]';
            $post_content = apply_filters('the_content', get_post_field('post_content', $post->ID));
            $title = '<div><h6>'.get_the_title($post->ID).'</h6><div>'.$department.'</div></div>';
            $postList .= '[su_spoiler title="'.$title.'" icon="chevron"] '.$post_content.'<a href="#career_form" data-position="'.get_the_title($post->ID).'" class="btn btn-default btn-dynamic">Apply Now</a> [/su_spoiler]';
        // dump($title);
        }
        $shortcode = '[su_accordion class="custom-su-accordion"]'.$postList.'[/su_accordion]';
        return do_shortcode($shortcode);
    else:
        // echo "no post";
    endif;

    // return $html; 
    wp_reset_query();
}


/****************************************************** WooCommerce ******************************************************/

/***Re-assign sorting value***/
add_filter( 'woocommerce_catalog_orderby', 'misha_remove_default_sorting_options' );
function misha_remove_default_sorting_options( $options ){
    unset( $options[ 'popularity' ] ); // Sort by popularity
    // unset( $options[ 'menu_order' ] ); // Default sorting
    unset( $options[ 'rating' ] ); // Sort by average rating
    unset( $options[ 'date' ] ); // Sort by latest
    unset( $options[ 'price' ] ); // Sort by price: low to high
    unset( $options[ 'price-desc' ] ); // Sort by price: high to low
    
    return $options;
    
}


add_filter( 'woocommerce_catalog_orderby', 'custom_woocommerce_catalog_orderby' );
function custom_woocommerce_catalog_orderby( $options ){
    
    $options[ 'title-a-to-z' ] = 'Name (A-Z)';
    $options[ 'title-z-to-a' ] = 'Name (Z-A)';
    $options[ 'newest-to-oldest' ] = 'Newest to Oldest';
    $options[ 'oldest-to-newest' ] = 'Oldest to Newest';
    
    return $options;
}

add_filter( 'woocommerce_get_catalog_ordering_args', 'custom_woocommerce_get_catalog_ordering_args' );
function custom_woocommerce_get_catalog_ordering_args( $args ) {
    
    // Sort title asc
    if ( isset( $_GET[ 'orderby' ] ) && 'title-a-to-z' === $_GET[ 'orderby' ] ) {
        $args[ 'orderby' ] = 'title';
        $args[ 'order' ] = 'asc';
    }
    
    // Sort title desc
    if( isset( $_GET[ 'orderby' ] ) && 'title-z-to-a' === $_GET[ 'orderby' ] ) {
        $args[ 'orderby' ] = 'title';
        $args[ 'order' ] = 'desc';
    }

    // Show Newest product
    if ( isset( $_GET[ 'orderby' ] ) && 'newest-to-oldest' === $_GET[ 'orderby' ] ) {
        $args[ 'orderby' ] = 'date';
        $args[ 'order' ] = 'desc';
    }

    // Show Oldest product
    if ( isset( $_GET[ 'orderby' ] ) && 'oldest-to-newest' === $_GET[ 'orderby' ] ) {
        $args[ 'orderby' ] = 'date';
        $args[ 'order' ] = 'asc';
    }
    
    return $args;
}


/*Remove Related Product*/
add_filter( 'woocommerce_product_related_products_heading', function(){ return ''; } );



/**********
**** Add 2nd image into Shop page Product 
*********/
add_shortcode( 'ninja_shopHoverImage', 'ninja_shopHoverImage' );
function ninja_shopHoverImage(){
    $html = '';
    $product = new WC_Product( get_the_ID() );
    $attachment_ids = $product->get_gallery_image_ids();

    if ( is_array( $attachment_ids ) && !empty($attachment_ids) ) {
        $first_image_url = wp_get_attachment_url( $attachment_ids[0] );
        // ... then do whatever you need to do
        $html .= '<a href="'.get_the_permalink().'"><img src="'.$first_image_url.'" class="product-hover-img"/></a>';
    } // No images found
    else {
        // @TODO
    }

    return $html; 
}


/**********
**** Add Custom Back Button into Single Product
*********/
add_shortcode( 'ninja_backButton', 'ninja_backButton' );
function ninja_backButton(){
    $html = '';
    // $full_html = '';
    // $current = get_queried_object();
    // $current_id = $current->ID;
    // $icon = types_render_field("product-features-icon", array("post_id"=>$current_id, "output"=>"raw"));
    // $icons = get_post_meta( get_the_ID(), 'wpcf-product-features-icon', false );

    $html .= '<div class="custom-back-btn-wrapper">';
    $html .= '<a href="#" onclick="history.back();"><i class="fas fa-chevron-left"></i>Back</a>';
    $html .= '</div>';

    return $html; 
}



/**********
**** Hide Tab section based on Single Product Description availability
*********/
add_shortcode( 'ninja_checkContent', 'ninja_checkContent' );
function ninja_checkContent(){
    
    $queried_object = get_queried_object();
    $current_content = $queried_object->post_content;
    if (!empty($current_content)){
        return '1';
    }else{
        return '0';
    }
}


/**
 * Add quantity field on the archive page.
 */
function custom_quantity_field_archive() {

    $product = wc_get_product( get_the_ID() );

    if ( ! $product->is_sold_individually() && 'variable' != $product->get_type() && $product->is_purchasable() ) {
        woocommerce_quantity_input( array( 'min_value' => 1, 'max_value' => $product->backorders_allowed() ? '' : $product->get_stock_quantity() ) );
    }

}
add_action( 'woocommerce_after_shop_loop_item', 'custom_quantity_field_archive', 0, 9 );


/**
 * Add requires JavaScript.
 */
function custom_add_to_cart_quantity_handler() {

    wc_enqueue_js( '
        jQuery( ".post-type-archive-product" ).on( "click", ".quantity input", function() {
            return false;
        });
        jQuery( ".post-type-archive-product" ).on( "change input", ".quantity .qty", function() {
            var add_to_cart_button = jQuery( this ).parents( ".product" ).find( ".add_to_cart_button" );
            // For AJAX add-to-cart actions
            add_to_cart_button.attr( "data-quantity", jQuery( this ).val() );
            // For non-AJAX add-to-cart actions
            add_to_cart_button.attr( "href", "?add-to-cart=" + add_to_cart_button.attr( "data-product_id" ) + "&quantity=" + jQuery( this ).val() );
        });
    ' );

}
add_action( 'init', 'custom_add_to_cart_quantity_handler' );


add_action( 'woocommerce_after_add_to_cart_quantity', 'ts_quantity_plus_minus_sign' );
function ts_quantity_plus_minus_sign() {
   echo '<button type="button" class="minus" ><i class="fa-solid fa-minus"></i></button><button type="button" class="plus" ><i class="fa-solid fa-plus"></i></button>';
}
 
// add_action( 'woocommerce_before_add_to_cart_quantity', 'ts_quantity_minus_sign' );
// function ts_quantity_minus_sign() {
//    echo '<button type="button" class="minus" >-</button>';
// }
 
add_action( 'wp_footer', 'ts_quantity_plus_minus' );
function ts_quantity_plus_minus() {
   // To run this on the single product page
   if ( ! is_product() ) return;
   ?>
   <script type="text/javascript">
          
      jQuery(document).ready(function($){   
          
            $('form.cart').on( 'click', 'button.plus, button.minus', function() {
 
            // Get current quantity values
            var qty = $( this ).closest( 'form.cart' ).find( '.qty' );
            var val   = parseFloat(qty.val());
            var max = parseFloat(qty.attr( 'max' ));
            var min = parseFloat(qty.attr( 'min' ));
            var step = parseFloat(qty.attr( 'step' ));
 
            // Change the value if plus or minus
            if ( $( this ).is( '.plus' ) ) {
               if ( max && ( max <= val ) ) {
                  qty.val( max );
               } 
            else {
               qty.val( val + step );
                 }
            } 
            else {
               if ( min && ( min >= val ) ) {
                  qty.val( min );
               } 
               else if ( val > 1 ) {
                  qty.val( val - step );
               }
            }
             
         });
          
      });
          
   </script>
   <?php
}

?>