<?php
/**
 * Extra functions for theme
 * @package ninja
 */

// Mark Posts/Pages as Untiled when no title is used
function ninja_title( $title ) {
	if ( $title == '' ) {
		return 'Untitled';
	} else {
		return $title;
	}
}
add_filter( 'the_title', 'ninja_title' );

/**
 * Customize the PageNavi HTML before it is output to support bootstrap
 */
function ninja_wp_pagenavi_bootstrap_markup( $html ) {
	$out = '';

	//wrap a's and span's in li's
	$out = str_replace( "<div", "", $html );
	$out = str_replace( "class='wp-pagenavi' role='navigation'>", "", $out );
	$out = str_replace( "<a", "<li><a", $out );
	$out = str_replace( "</a>", "</a></li>", $out );
	$out = str_replace( "<span", "<li><span", $out );
	$out = str_replace( "</span>", "</span></li>", $out );
	$out = str_replace( "</div>", "", $out );

	return '<div class="navigation text-center"><ul class="pagination justify-content-center wp-pagenavi-pagination">' . $out . '</ul></div>';
}
add_filter( 'wp_pagenavi', 'ninja_wp_pagenavi_bootstrap_markup' );

// Add Bootstrap classes for table
function ninja_add_bootstrap_table_class( $content ) {
	return preg_replace( '/(<table) ?(([^>]*)class="([^"]*)")?/', '$1 $3 class="$4 table" ', $content);
}
add_filter( 'the_content', 'ninja_add_bootstrap_table_class' );

/**
 * Add Bootstrap thumbnail styling to images with captions
 * Use <figure> and <figcaption>
 *
 * @link http://justintadlock.com/archives/2011/07/01/captions-in-wordpress
 */
function ninja_bootstrap_caption($output, $attr, $content) {
  if (is_feed()) {
    return $output;
  }

  $defaults = array(
    'id'      => '',
    'align'   => 'alignnone',
    'width'   => '',
    'caption' => '',
    'class'   => ''
  );

  $attr = shortcode_atts($defaults, $attr);

  // If the width is less than 1 or there is no caption, return the content wrapped between the [caption] tags
  if ($attr['width'] < 1 || empty($attr['caption'])) {
    return $content;
  }

  // Set up the attributes for the caption <figure>
  $attributes  = (!empty($attr['id']) ? ' id="' . esc_attr($attr['id']) . '"' : '' );
  $attributes .= ' class="thumbnail wp-caption ' . esc_attr($attr['align']) . ' ' . esc_attr($attr['class']) . '"';
  $attributes .= ' style="width: ' . (esc_attr($attr['width']) + 10) . 'px"';

  $output  = '<figure' . $attributes .'>';
  $output .= do_shortcode($content);
  $output .= '<figcaption class="caption wp-caption-text">' . $attr['caption'] . '</figcaption>';
  $output .= '</figure>';

  return $output;
}
add_filter('img_caption_shortcode', 'ninja_bootstrap_caption', 10, 3);

/**
 * Font Awesome shortcodes
 */
add_shortcode( 'fa', 'shortcode_icon' );
function shortcode_icon( $atts ){
    $n = shortcode_atts( array(
        'xclass'    => '',
        'icon'      => '',
        'size'      => '',
        'brand'     => 0,
        'regular'   => 0,
        'fw'        => 0,
    ), $atts );

    $xclass     = $n['xclass'];
    $icon       = $n['icon'];
    $size       = $n['size'];
    $brand      = $n['brand'];
    $regular    = $n['regular'];
    $fw         = $n['fw'];

    // Exit function if no icon class provided
    if( empty( $icon ) ){ return; }

    // Determine if brand style or regular or solid
    if ( $brand === 'false' ) { $brand = false; }
    $brand = (bool) $brand;

    if ( $regular === 'false' ) { $regular = false; }
    $regular = (bool) $regular;

    if ( $brand === true ){
        $class_array[] = 'fab';
    } elseif ( $regular === true ){
        $class_array[] = 'far';
    } else {
        $class_array[] = 'fas';
    }

    // Replace any empty space with dash & add icon class to array
    $icon = str_replace(' ', '-', $icon);
    $class_array[] = 'fa-' . $icon;

    // Determine if fixed width enabled
    if ( $fw === 'false' ) { $fw = false; }
    $fw = (bool) $fw;

    if ( $fw === true ){
        $class_array[] = 'fa-fw';
    }

    // Icon Size
    $size_opts = array('xs', 'sm', 'lg', '2x', '3x', '4x', '5x', '6x', '7x', '8x', '9x', '10x');
    $size_result = count(array_filter($size_opts, create_function('$e','return strstr("'.$size.'", $e);')))>0;
    if( !empty( $size ) && $size_result !== false ){
        $class_array[] = 'fa-' . $size;
    }

    // Add extra classes
    if ( !empty( $xclass ) ){
        $class_array[] = $xclass;
    }

    return '<i class="' . implode( ' ', $class_array ) . '"></i>';
}

/**
 * Change CF7 Submit Input to Button
 */
remove_action( 'wpcf7_init', 'wpcf7_add_form_tag_submit', 0 );
add_action( 'wpcf7_init', 'wpcf7_add_form_tag_submit_button', 0 );
function wpcf7_add_form_tag_submit_button() { 
    wpcf7_add_form_tag( 'submit', 'wpcf7_submit_button_form_tag_handler' ); 
}
function wpcf7_submit_button_form_tag_handler( $tag ) {
    $class = wpcf7_form_controls_class( $tag->type );

    $atts = array();

    $atts['class'] = $tag->get_class_option( $class ) . ' btn btn-default';
    $atts['id'] = $tag->get_id_option();
    $atts['tabindex'] = $tag->get_option( 'tabindex', 'signed_int', true );

    $value = isset( $tag->values[0] ) ? $tag->values[0] : '';

    if ( empty( $value ) ) {
        $value = __( 'Send', 'contact-form-7' );
    }

    $atts['type'] = 'submit';
    $atts['data-text'] = $value;
    $atts = wpcf7_format_atts( $atts );
    $html = sprintf(    '<button %1$s>%2$s</button>', 
                        $atts, 
                        $value );
    return $html;
}