<?php
/**
 * Ninja functions and definitions
 *
 * @package ninja
 */

 /**
  * @file - init.php
  * @desc - Contain standard script and function to initial project in beginning stage.
  * @path - theme template folder  > init.pp
 */
include "init.php";

/**
 * @return any - return templete section structure or custom query 
 * @desc - to organize the file structure and easy to debug script. this function will get the templete, php script or custom WP_QUERY from the component folder and apply to the give shortcode name.
 */
// add_shortcode( '<name-of-the-shortcode>', '<func-name>');
// function <func-name>(){
//     ob_start();

//     do_shortcode(get_template_part('components/<page-folder>/<feature-name>','<type>')); //example::do_shortcode(get_template_part('components/home/product-category','section'))
      
//     wp_reset_query();

//     return ob_get_clean(); 
// }


/**********
**** List Events
*********/
add_shortcode( 'ninja_eventList', 'ninja_eventList' );
function ninja_eventList(){
    ob_start();
    get_template_part('components/newsEvent'); 
    wp_reset_query();
    return ob_get_clean(); 
    // ob_start();
    // $postList ='';
    // $compare = '';
    // $value = 'upcoming';
    // if (isset($_GET["category"])){
    //     $value = $_GET["category"];
    // }
    // if ($value == 'upcoming'){
    //     $compare = '>=';
    // }else{
    //     $compare = '<=';
    // }
    // // var_dump(strtotime("now"));
    // $args = array(
    //         'post_type' => 'post',
    //         'orderby' => 'date',
    //         'order'   => 'Desc',
    //         'posts_per_page' => '10',
    //         'paged' => get_query_var('paged'),
    //         'meta_key'    => 'wpcf-event-end-date', 
    //         'tax_query' => array(
    //             array(
    //                 'taxonomy' => 'category',
    //                 'field'    => 'slug',
    //                 'terms'    => 'news-event',
    //             ),
    //         ),
    //         'meta_query' => array(
    //             array(
    //                 'key'     => 'wpcf-event-end-date',
    //                 'value'   => strtotime("now"),
    //                 'compare' => $compare,
    //                 'type' => 'numeric'
    //             ),
    //         ),
    //     );
    // $query = new WP_Query( $args ); 

    // $postList ='<ul class="ntype-list events-nav ">';
    // if ($value != 'past'){
    //     $postList .= '<li class="nav-active">';
    // }else{
    //     $postList .= '<li>';
    // }
    // $postList .= '<a href="'.get_site_url().'/news-event/?category=upcoming">Upcoming</a></li>';

    // if ($value == 'past'){
    //     $postList .= '<li class="nav-active">';
    // }else{
    //     $postList .= '<li>';
    // }
    // $postList .= '<a href="'.get_site_url().'/news-event/?category=past">Past</a></li>';
    // $postList .= '</ul>';

    // if ( $query->have_posts() ) :
    //     $postList .= '<div class="event-wrapper">';

    //     $postList .='<ul class="cat-list cat-listing ntype-list events-list ">';
    //     while ( $query->have_posts() ) : $query->the_post();
    //         if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
    //             $thumb_id = get_post_thumbnail_id();
    //             $thumb_url_array = wp_get_attachment_image_src($thumb_id, 'thumbnail-size', true);
    //             $thumb_url = $thumb_url_array[0];
    //         } 

    //         $html = '';
    //         $start = types_render_field("event-start-date", array("output"=>"normal"));
    //         $end = types_render_field("event-end-date", array("output"=>"normal"));
    //         $venue = types_render_field("venue", array("output"=>"raw"));
    //         $booth = types_render_field("booth", array("output"=>"raw"));
    //         $link = types_render_field("external-link", array("output"=>"raw"));

    //         if (!empty($start)){
    //             $html .= $start;
    //             if (!empty($end)){
    //                 $html .= ' - '.$end;
    //             }
    //         }


    //         $postList .= '<li>';
    //         $postList .= '<div class="block inner-nbox nbox-shadow">';
    //         $postList .= '<div class="img-wrapper"><img src="'.$thumb_url.'"/></div>';
    //         $postList .= '<div class="post-content-wrapper">';
    //         $postList .= '<div class="contain-wrapper">';
    //         $postList .= '<h5 class="">'.get_the_title().'</h5>';
    //         $postList .= '<div class="inner-contain-wrapper">';
    //         $postList .= '<div class="npost-venue">'.$venue.'</div>';
    //         $postList .= '<div class="npost-booth">Booth: '.$booth.'</div>';
    //         $postList .= '<div class="npost-date">'.$html.'</div>';
    //         $postList .= '<a href="'.$link.'" class="btn btn-default btn-lg" target="_blank">' .__("Read More","ninja"). '</a>';
    //         $postList .= '</div>';//inner-contain-wrapper
    //         $postList .= '</div>';//contain-wrapper+
    //         $postList .= '</div>';
    //         $postList .= '</div>';
    //         $postList .= '</li>';
            
    //     endwhile;

    //     $postList .= '</ul>';
    //     wp_pagenavi( array( 'query' => $query ) );
    //     return $postList; 
    //     $postList .= '</div>';

    // else:
    //     $postList .= "<p class='coming-soon-content'>Stay tuned for more exciting events.</p>";
    //     return $postList; 
    // endif;
    //     // wp_reset_postdata();
    // wp_reset_query();
    // return ob_get_clean(); 

}



/**
 * Create a list of news & event archive to use in sidebar
 */
add_shortcode( 'list_newsevents_archive', 'list_newsevents_archive' );
function list_newsevents_archive(){
    wp_reset_query();
    
    $att = '0';

    $product_list='';
    $product_list .='<aside>';
    // $product_list .='<h3>'. __("Archive","ninja").'</h3>';

    $taxonomy_name = 'archive-by-year';
    $taxonomy = get_query_var( 'taxonomy' );
    $current_post = '';
    if (is_single()){
        $current_post =  get_queried_object_id();
    }
    

    $args = array(
                'taxonomy' => $taxonomy_name,
                'orderby'       => 'name',
                'order' => 'DESC',
                'hide_empty'    => 1,
                'parent'        => $att,
                // 'exclude'       => 15,
            );
    $terms = get_terms( $args );

    if ( !empty( $terms ) && !is_wp_error( $terms && count($terms)) ){

        $product_list.='<ul id="menu-archive-year" class="menu-product classExpand">';

        foreach ( $terms as $term ) {//*Term foreach open*//
            $queried_object = get_queried_object();
            if (is_tax($taxonomy_name)){
                $current_term_id =  (int) $queried_object->term_id;
            }else{
                $current_term_id =  '0';
            }
            

            $active_term = '';
            if ( $current_term_id === $term->term_id ) {
                $active_term = 'active';
                $product_list.='<li class="'.$active_term.'">';
            }else{
                $product_list.='<li>';
            }

            $product_list.='<a href="'.get_term_link($term).'">'. $term->name.'</a>';

            $product_list.='</li>';
        }//*Term foreach close*//
        $product_list.='</ul><!--end product category-->';
    }
        $product_list .='</aside>';
    echo $product_list;
}


/**********
**** List E-Studio Posts
*********/
add_shortcode( 'ninja_estudioPosts', 'ninja_estudioPosts' );
function ninja_estudioPosts(){
    $postList ='';
    $html = '';
    $album = '';
    $album_thumb = '';
    $shortcode_main = '';
    $i = '0';
    $current_term_id = '';

    if(is_tax()){
        $queried_object = get_queried_object();
        $current_term_id = (int) $queried_object->term_id;
        
        $args = array(
            'post_type' => 'e-studio',
            'order'   => 'Asc',
            'orderby'   => 'name',
            'posts_per_page' => '-1',
            'tax_query' => array(
                array(
                    'taxonomy' => 'e-studios-category',
                    'terms'    => $current_term_id,
                ),
            ),
        );
    }else{
        $args = array(
            'post_type' => 'e-studio',
            'order'   => 'Asc',
            'orderby'   => 'name',
            'posts_per_page' => '-1',
        );
    }
    

    $term_args = array( 
            'taxonomy' => 'e-studios-category', 
            // 'orderby' => 'id', 
            'order' => 'ASC', 
            'hide_empty' => 0,
            'parent' => 0,
            // 'exclude' => 15,
        ); 
    $terms = get_terms( $term_args );
    if ( !empty( $terms ) && !is_wp_error( $terms && count($terms)) ){
        $postList .= '<ul class="cat-list cat-listing ntype-list estudio-cat-list">';

        foreach ( $terms as $term ) {
            $postList .= '<li>';
            $postList .= '<div class="inner-nbox">';
            // dump($current_term_id.'/'.$term->term_id);
            if($current_term_id == $term->term_id){
                $postList .= '<a href="'.get_term_link( $term ).'" class="active">';
            }else{
                $postList .= '<a href="'.get_term_link( $term ).'" class="">';
            }
            $postList .= $term->name;
            $postList .= '</a>';
            $postList .= '</div>'; 
            $postList .= '</li>';
        }
        $postList .='</ul><!--end e-studio category-->';
    }
    

    $postList .='<div class="custom-tab-wrapper ">';

    $query = get_posts( $args ); 
    if ( $query ) :
        
        foreach ($query as $post) {
            $i = $i+1;
            $floor = types_render_field("floor-image", array("post_id"=>$post->ID, "output"=>"raw"));
            $room = types_render_field("room-image", array("post_id"=>$post->ID, "output"=>"raw"));

            $resize_floor = str_replace(".jpg","-150x150.jpg", $floor);

            if ($i == '1'){
                $album_thumb .= '<li><a href="#'.$post->post_name.'" class="active"><div class="img-wrapper"><img src="'.$resize_floor.'" /></div><h6>'.get_the_title($post->ID).'</h6></a></li>';
            }else{
                $album_thumb .= '<li><a href="#'.$post->post_name.'"><div class="img-wrapper"><img src="'.$resize_floor.'" /></div><h6>'.get_the_title($post->ID).'</h6></a></li>';
            }
            
            $shortocde_sub .= '[su_tab title="'.get_the_title($post->ID).'" disabled="no" anchor="'.$post->post_name.'" url="" target="blank" class=""]<img src="'.$room.'" />[/su_tab]';
        }
        
        $postList .='<div class="custom-tabs-nav-wrapper "><ul class="ntype-list custom-tabs-nav ">'.$album_thumb.'</ul></div>';
        $shortcode_main = '[su_tabs anchor_in_url="yes"]'.$shortocde_sub.'[/su_tabs]';

    endif;
    
    


    // wp_reset_postdata();

    return $postList.$shortcode_main;
    $postList .= '</div>';
}


add_filter( 'woocommerce_single_product_image_gallery_classes', 'bbloomer_5_columns_product_gallery' );
 
function bbloomer_5_columns_product_gallery( $wrapper_classes ) {
   $columns = 5; // change this to 2, 3, 5, etc. Default is 4.
   $wrapper_classes[2] = 'woocommerce-product-gallery--columns-' . absint( $columns );
   return $wrapper_classes;
}