<?php
/**
 * Ninja functions and definitions
 *
 * @package ninja
 */

 /**
  * @file - init.php
  * @desc - Contain standard script and function to initial project in beginning stage.
  * @path - theme template folder  > init.pp
 */
include "init.php";

/**
 * @return any - return templete section structure or custom query 
 * @desc - to organize the file structure and easy to debug script. this function will get the templete, php script or custom WP_QUERY from the component folder and apply to the give shortcode name.
 */
// add_shortcode( '<name-of-the-shortcode>', '<func-name>');
// function <func-name>(){
//     ob_start();

//     do_shortcode(get_template_part('components/<page-folder>/<feature-name>','<type>')); //example::do_shortcode(get_template_part('components/home/product-category','section'))
      
//     wp_reset_query();

//     return ob_get_clean(); 
// }

/**********
**** List E-Studio Posts
*********/
add_shortcode( 'ninja_estudioPosts', 'ninja_estudioPosts' );
function ninja_estudioPosts(){
    $postList ='';
    $html = '';
    $album = '';
    $album_thumb = '';
    $shortcode_main = '';
    $i = '0';

    $args = array(
            'post_type' => 'e-studio',
            'order'   => 'Asc',
            'posts_per_page' => '-1',
        );

    $postList ='<div class="custom-tab-wrapper ">';

    $query = get_posts( $args ); 
    if ( $query ) :
        
        foreach ($query as $post) {
            $i = $i+1;
            $floor = types_render_field("floor-image", array("post_id"=>$post->ID, "output"=>"raw"));
            $room = types_render_field("room-image", array("post_id"=>$post->ID, "output"=>"raw"));

            if ($i == '1'){
                $album_thumb .= '<li><a href="#'.$post->post_name.'" class="active"><img src="'.$floor.'" /><h6>'.get_the_title($post->ID).'</h6></a></li>';
            }else{
                $album_thumb .= '<li><a href="#'.$post->post_name.'"><img src="'.$floor.'" /><h6>'.get_the_title($post->ID).'</h6></a></li>';
            }
            
            $shortocde_sub .= '[su_tab title="'.get_the_title($post->ID).'" disabled="no" anchor="'.$post->post_name.'" url="" target="blank" class=""]<img src="'.$room.'" />[/su_tab]';
        }
        
        $postList .='<div class="custom-tabs-nav-wrapper "><ul class="ntype-list custom-tabs-nav ">'.$album_thumb.'</ul></div>';
        $shortcode_main = '[su_tabs anchor_in_url="yes"]'.$shortocde_sub.'[/su_tabs]';

    endif;
    
    


    // wp_reset_postdata();

    return $postList.$shortcode_main;
    $postList .= '</div>';
}